% Function: This is the program that generates an excel csv output with the 
% p-values and fold changes for all of the IP/Probe combinations 

% Inputs:
% ExpHitCell - a complicated cell array that contains information about the
%    identity, number, matrix index of the significant hits
% PValueCell - a cell array, where each entry is another cell array that 
%    contains the matrices with the significance values for a each 
%    comparison in a given experiment
% Log2FCCell - a cell array, where each entry is another cell array that 
%    contains the matrices with the log2fold change values for a each 
%    comparison in a given experiment
% ExpNum - a numerical value for the number of experiments performed
% ConditionNum - a numerical value for the number of conditions/comparisons
%    performed
% IPProbeNum - a numerical value with the number of IP/Probe combinations
%    measured
% ConditionId - a cell array where the entries are strings naming the
%    different conditions/combinations being performed
% IPProbeList - a cell array with the names of the IP/Probes listed as
%    strings
% Filename - a string naming the file of the output

% Outputs:
% OutputList - an output listing the data as it is formatted in the excel
% csv file

function [OutputList] = ExcelAllOutput(ExpHitCell,PValueCell,Log2FCCell,...
    ExpNum,ConditionNum,IPProbeNum,ConditionId,IPProbeList,FileName)

StringFormat = strcat('%s,',repmat('%d,',1,ExpNum),...
    repmat('%f,',1,ExpNum+2),'\n');

for alpha = 1:ConditionNum
    
    fid = fopen(strcat(ConditionId{alpha},FileName),'wt');
    OutputList = zeros(IPProbeNum,ExpNum*2+2);
    
    for i = 1:ExpNum

        OutputList(:,i) = PValueCell{i}{alpha}(:);
        OutputList(:,ExpNum+i) = Log2FCCell{i}{alpha}(:);

    end
    
    OutputList(ExpHitCell{alpha}{2}{ExpNum}{1}{1},ExpNum*2+1) = 1;
    OutputList(ExpHitCell{alpha}{2}{ExpNum}{1}{2},ExpNum*2+2) = 1;
    
    OutputCell = cell(IPProbeNum,ExpNum*2+3);

    [OutputCell(:,1)] = IPProbeList;
    [OutputCell(:,2:end)] = num2cell(OutputList);
    
    for j=1:size(OutputList,1)
            fprintf(fid,StringFormat, OutputCell{j,:});
    end

    fclose(fid);
end
